BaleCollectChangeSettingsEvent = {};
BaleCollectChangeSettingsEvent_mt = Class(BaleCollectChangeSettingsEvent, Event);
InitEventClass(BaleCollectChangeSettingsEvent, "BaleCollectChangeSettingsEvent");

BaleCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
BaleCollectChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function BaleCollectChangeSettingsEvent.emptyNew()
    local self = Event.new(BaleCollectChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function BaleCollectChangeSettingsEvent.new(settingsId, settingsState)
    local self = BaleCollectChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function BaleCollectChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, BaleCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, BaleCollectChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function BaleCollectChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, BaleCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, BaleCollectChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function BaleCollectChangeSettingsEvent:run(connection)	
	--if self.settingsId == "baleCollectMission_onOff" then
	--	g_additionalContractTypes:getTyp("baleCollectMission"):setOnOff(g_additionalContractUtils:getTypToString(self.settingsState));		
	if self.settingsId == "baleCollectMission_minMax" then
		g_additionalContractTypes:getTyp("baleCollectMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

