BaleCollectLoadSettingsEvent = {};
BaleCollectLoadSettingsEvent_mt = Class(BaleCollectLoadSettingsEvent, Event);
InitEventClass(BaleCollectLoadSettingsEvent, "BaleCollectLoadSettingsEvent");

BaleCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function BaleCollectLoadSettingsEvent.emptyNew()
    local self = Event.new(BaleCollectLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function BaleCollectLoadSettingsEvent.new(minMax)
    local self = BaleCollectLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function BaleCollectLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then        
        self.minMax = streamReadInt8(streamId, BaleCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function BaleCollectLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["baleCollectMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["baleCollectMission_minMax"], BaleCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function BaleCollectLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(BaleCollectLoadSettingsEvent.new(g_additionalContractTypes.settings["baleCollectMission_minMax"]), false);				
		return;
	end;
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["baleCollectMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


