VehicleStatisticMarker = {};

VehicleStatisticMarker.metadata = {
	interface = "FS25 ...", --new LS25
	title = "VehicleStatisticMarker",
	notes = "Dieser Mod Selektiert das gerade benutzte Fahrzeug und angehängte Geräte in der Fahrzeug Statistik.",
	author = "(by HappyLooser)",
	version = "1.0.0.0",
	build = 3,
	datum = " 17.03.2025",
	update = " 21.05.2025",
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function VehicleStatisticMarker:loadMap(mapName)
	print("---loading ".. tostring(VehicleStatisticMarker.metadata.title).. " ".. tostring(VehicleStatisticMarker.metadata.version).. "(#".. tostring(VehicleStatisticMarker.metadata.build).. ") ".. tostring(VehicleStatisticMarker.metadata.author).. "---")	
	if VehicleStatisticMarker:getDetiServer() then return;end;
	Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, VehicleStatisticMarker.onStartMission);
	VehicleStatisticMarker:loadFunctions();	
	VehicleStatisticMarker.openInGameMenu = false;
end;

function VehicleStatisticMarker:onStartMission()
	if g_currentMission.hlUtils ~= nil then
		g_currentMission.hlUtils.modLoad("FS25_VehicleStatisticMarker");
		VehicleStatisticMarker:setGlobalFunction();
	end;
	VehicleStatisticMarker:createdAttributes();
end;

function VehicleStatisticMarker:update(dt)	
	if VehicleStatisticMarker:getDetiServer() then return;end;	
	if g_localPlayer ~= nil then
		--if g_inGameMenu.isOpen then if VehicleStatisticMarker.frameVehiclesByMod ~= nil then VehicleStatisticMarker:setFrameVehiclesByMod();end;end;
		if not g_inGameMenu.isOpen then VehicleStatisticMarker:setFrameVehicles();end;
	end;
end;
addModEventListener(VehicleStatisticMarker);

function VehicleStatisticMarker:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function VehicleStatisticMarker:setFrameVehiclesByMod()
	--VehicleStatisticMarker.frameVehicles = VehicleStatisticMarker.frameVehiclesByMod;
	--VehicleStatisticMarker.frameVehiclesByMod = nil;
	--InGameMenuStatisticsFrame:updateView(g_inGameMenu.pageStatistic);	
end;

function VehicleStatisticMarker:getFrameVehicles()
	if g_localPlayer.getCurrentVehicle ~= nil and g_localPlayer:getIsInVehicle() then
		return VehicleStatisticMarker.frameVehicles or VehicleStatisticMarker.frameVehiclesByMod;
	else
		return VehicleStatisticMarker.frameVehiclesByMod;
	end;
end;

function VehicleStatisticMarker:setFrameVehicles(mod, vehicles)
	if mod == nil or not mod then
		if g_localPlayer.getCurrentVehicle ~= nil and g_localPlayer:getIsInVehicle() then
			local vehicle = g_localPlayer:getCurrentVehicle();
			if vehicle ~= nil and vehicle.trainSystem == nil and vehicle.spec_rideable == nil and vehicle.propertyState < 4 and vehicle:getShowInVehiclesOverview() then
				local vehicles = {};
				vehicles[vehicle.rootNode] = true;				
				for _, attachedVehicle in ipairs(vehicle.rootVehicle:getChildVehicles()) do
					if attachedVehicle:getShowInVehiclesOverview() then
						if attachedVehicle.trainSystem == nil and attachedVehicle.spec_rideable == nil then
							if vehicles[attachedVehicle.rootNode] == nil then vehicles[attachedVehicle.rootNode] = false;end;							
						end;
					end;
				end;
				VehicleStatisticMarker.frameVehicles = vehicles;				
			else
				VehicleStatisticMarker.frameVehicles = nil;				
			end;		
		end;
	else
		VehicleStatisticMarker.frameVehiclesByMod = vehicles;
	end;
end;

function VehicleStatisticMarker:createdAttributes()
	for a=1, 2 do
		local marker = g_inGameMenu.vehiclesList.cellDatabase.rowTemplate:getDescendantByName("name")
		local profil = marker:clone(g_inGameMenu.vehiclesList.cellDatabase.rowTemplate)
		if a == 1 then
			profil.name = "markerMaster";
		else
			profil.name = "markerAttached"
		end;
		profil:setPosition(-50/2560 *g_aspectScaleX, nil);
		profil.textBold = true;	
		profil:applyProfile("fs25_vehiclesListItem");
		profil.textColor = {255/255,255/255,0/255,1.00}; --yellow
		profil.textSelectedColor = profil.textColor;
		profil:setVisible(false);
		if a == 1 then
			profil:setText(">>");			
		else
			profil:setText("-o");			
		end;
	end;	
end;

function VehicleStatisticMarker:loadFunctions()
	function VehicleStatisticMarker:populateCellForItemInSection(page, pageIndex, vehicleId, vehiclePage)
		if page == self.vehiclesList then		
			local markerMaster = vehiclePage:getAttribute("markerMaster");
			local markerAttached = vehiclePage:getAttribute("markerAttached");
			if markerMaster ~= nil and markerAttached ~= nil then
				function setVisible(master, state)
					if master == nil or master then
						if markerMaster ~= nil then markerMaster:setVisible(state);end;
					else
						if markerAttached ~= nil then markerAttached:setVisible(state);end;
					end;
				end;
				local vehicles = self.vehicles[vehicleId];
				local vehicle = vehicles.vehicle;		
				if g_storeManager:getItemByXMLFilename(vehicle.configFileName) ~= nil then			
					function searchRootNode()				
						local frameVehicles = VehicleStatisticMarker:getFrameVehicles();
						if frameVehicles ~= nil and frameVehicles[vehicle.rootNode] ~= nil then
							return true, frameVehicles[vehicle.rootNode];
						end;						
						return false;						
					end;			
					local name = vehiclePage:getAttribute("name");
					if name ~= nil then			
						local foundVehicle, masterVehicle = searchRootNode();
						if foundVehicle then 					
							if masterVehicle then
								setVisible(true, true);
							else
								setVisible(false, true);
							end;					
						else
							setVisible(true, false);
							setVisible(false, false);
						end;			
					else
						setVisible(true, false);
						setVisible(false, false);
					end;		
				else
					setVisible(true, false);
					setVisible(false, false);
				end;
			end;
		end;
	end;
	InGameMenuStatisticsFrame.populateCellForItemInSection = Utils.appendedFunction(InGameMenuStatisticsFrame.populateCellForItemInSection, VehicleStatisticMarker.populateCellForItemInSection);
	
	function VehicleStatisticMarker:updateView()
		if self.vehicles ~= nil and #self.vehicles > 1 then
			local frameVehicles = VehicleStatisticMarker:getFrameVehicles();
			if frameVehicles ~= nil then
				function getMasterFrameVehicle()
					if frameVehicles ~= nil then
						for k,v in pairs(frameVehicles) do
							if v == true then return k;end;
						end;					
					end;
					return false;
				end;
				local vehicles = {}
				local nodeId = getMasterFrameVehicle();			
				local vehicle = g_currentMission.nodeToObject[nodeId];				
				for a=1, #self.vehicles do
					if frameVehicles[self.vehicles[a].vehicle.rootNode] ~= nil then
						if frameVehicles[self.vehicles[a].vehicle.rootNode] then 
							self.vehicles[a].newSort = 20000;
						else
							self.vehicles[a].newSort = 19999;
						end;					
					else
						self.vehicles[a].newSort = a;
					end;
				end;					
				function comp(w1,w2)		
					if w1.newSort > w2.newSort then
						return true;
					end;				
				end;
				table.sort(self.vehicles, comp);
				self.vehiclesList:reloadData()
				self.detailBox:setVisible(self.vehiclesList:getItemCount() > 0)
				self:updateMenuButtons()
			end;	
		end;
	end;
	InGameMenuStatisticsFrame.updateView = Utils.appendedFunction(InGameMenuStatisticsFrame.updateView, VehicleStatisticMarker.updateView);
end;

function VehicleStatisticMarker:setGlobalFunction()
	g_currentMission.hlUtils.globalFunction["FS25_VehicleStatisticMarker"] = {
		setFrameVehicles = function(vehicles)VehicleStatisticMarker:setFrameVehicles(true, vehicles);end;
	};	
end;